package gov.va.med.mhv.sm.admin.jpa.repository;

import gov.va.med.mhv.sm.admin.jpa.model.PatientBlockedTriageGroup;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PatientBlockedTriageGroupRepository extends JpaRepository<PatientBlockedTriageGroup, Long>{
	
	@Query("from PatientBlockedTriageGroup where patientId=:patientId and blocked=1")
	List<PatientBlockedTriageGroup> getPatientBlockedTriageGroupsByPatientId(@Param("patientId") Long patientId);
	
	@Query("from PatientBlockedTriageGroup ptbg where ptbg.triageGroupId=:triageGroupId and blocked=1")
	List<PatientBlockedTriageGroup> getBlockedPatientsDetailsByTriageGroupId(@Param("triageGroupId") Long triageGroupId);
	
	
	
	
}